<?php
/*
=====================================================
 DleMovie (Module for CMS DataLife Engine)
-----------------------------------------------------
 Copyright (c) 2011 Alexander Ahminenko
=====================================================
     
-----------------------------------------------------
 E-Mail, ICQ: a.ahminenko@gmail.com, 681216
=====================================================
*/
@session_start( );
@error_reporting( E_ALL ^ E_WARNING ^ E_NOTICE );
@ini_set( 'display_errors', true );
@ini_set( 'html_errors', false );
@ini_set( 'error_reporting', E_ALL ^ E_WARNING ^ E_NOTICE );

define( 'DATALIFEENGINE', true );
define( 'ROOT_DIR', '../../../..' );
define( 'ENGINE_DIR', ROOT_DIR . '/engine' );
define( 'DLEMOVIE_DIR', ROOT_DIR . '/engine/modules/dlemovie' );

include_once ENGINE_DIR . '/data/config.php';
include_once ENGINE_DIR . '/classes/mysql.php';
include_once ENGINE_DIR . '/data/dbconfig.php';
include_once ENGINE_DIR . '/modules/functions.php';
include_once ENGINE_DIR . '/classes/templates.class.php';
include_once ENGINE_DIR . '/classes/parse.class.php';

include_once ENGINE_DIR . '/data/dlemovie.php';
include_once DLEMOVIE_DIR . '/classes/dlemovie.class.php';

$parse = new ParseFilter( );
$dlemovie = new DleMovie( $db, $dlemovie_config, $config );
$dle_module = 'video';

$_REQUEST['skin'] = trim( totranslit( $_REQUEST['skin'], false, false ) );
if ( $_REQUEST['skin'] == "" OR ! @is_dir( ROOT_DIR . '/templates/' . $_REQUEST['skin'] ) ) {
    die( "Hacking attempt!" );
}
$user_group = get_vars( "usergroup" );
if( ! $user_group ) {
    $user_group = array( );
    $db->query( "SELECT * FROM " . USERPREFIX . "_usergroups ORDER BY id ASC" );
    while ( $row = $db->get_row( ) ) {
        $user_group[$row['id']] = array( );
        foreach ( $row as $key => $value ) {
            $user_group[$row['id']][$key] = stripslashes( $value );
        }
    }
    set_vars( "usergroup", $user_group );
    $db->free( );
}
$banned_info = get_vars( "banned" );
if ( ! is_array ( $banned_info )) {
    $banned_info = array( );
    $db->query ( "SELECT * FROM " . USERPREFIX . "_banned" );
    while ( $row = $db->get_row( ) ) {
        if ($row['users_id']) {
            $banned_info['users_id'][$row['users_id']] = array( 'users_id' => $row['users_id'], 'descr' => stripslashes( $row['descr'] ), 'date' => $row['date'] );
        } else {
            if ( count( explode ( ".", $row['ip'] ) ) == 4 )
                $banned_info['ip'][$row['ip']] = array( 'ip' => $row['ip'],  'descr' => stripslashes( $row['descr'] ),  'date' => $row['date'] );
            elseif ( strpos( $row['ip'], "@" ) !== false )
                $banned_info['email'][$row['ip']] = array( 'email' => $row['ip'], 'descr' => stripslashes( $row['descr'] ), 'date' => $row['date'] );
            else $banned_info['name'][$row['ip']] = array( 'name' => $row['ip'], 'descr' => stripslashes( $row['descr'] ), 'date' => $row['date'] );
        }
    }
    set_vars( "banned", $banned_info );
    $db->free( );
}

include_once ROOT_DIR . '/language/' . $config['langs'] . '/website.lng';
$config['charset'] = ( $lang['charset'] != '' ) ? $lang['charset'] : $config['charset'];
include_once ENGINE_DIR . '/modules/sitelogin.php';
if ( ! $is_logged ) $member_id['user_group'] = 5;
if ( check_ip( $banned_info['ip'] ) or $user_group[$member_id['user_group']]['dm_add_comment'] != 1 ) die( "error" );

$tpl = new dle_template( );
$tpl->dir = ROOT_DIR . '/templates/' . $_REQUEST['skin'];
define( 'TEMPLATE_DIR', $tpl->dir );

$_POST['name'] = convert_unicode( $_POST['name'], $config['charset']  );
$_POST['mail'] = convert_unicode( $_POST['mail'], $config['charset'] );
$_POST['comments'] = convert_unicode( $_POST['comments'], $config['charset'] );

$parse->safe_mode = true;
$parse->allow_url = $user_group[$member_id['user_group']]['allow_url'];
$parse->allow_image = $user_group[$member_id['user_group']]['allow_image'];

$_TIME = time( ) + ( $config['date_adjust'] * 60 );
$_IP = $db->safesql( $_SERVER['REMOTE_ADDR'] );
$name = $db->safesql( $parse->process( trim( $_POST['name'] ) ) );
$not_allow_symbol = array ("\x22", "\x60", "\t", '\n', '\r', "\n", "\r", '\\', ",", "/", "", "#", ";", ":", "~", "[", "]", "{", "}", ")", "(", "*", "^", "%", "$", "<", ">", "?", "!", '"', "'" );
$mail = $db->safesql(trim( str_replace( $not_allow_symbol, '', strip_tags( stripslashes( $_POST['mail'] ) ) ) ) );
$video_id = intval( $_POST['video_id'] );
$stop = array( );

if ( $is_logged ) {
    $name = $db->safesql( $member_id['name'] );
    $mail = $db->safesql( $member_id['email'] );
}
if ( $config['allow_comments_wysiwyg'] != "yes" ) $comments = $parse->BB_Parse( $parse->process( trim( $_POST['comments'] ) ), false );
else {
    $parse->wysiwyg = true;
    $parse->ParseFilter( Array ('div', 'span', 'p', 'br', 'strong', 'em', 'ul', 'li', 'ol' ), Array( ), 0, 1 );
    if ( $user_group[$member_id['user_group']]['allow_url'] ) $parse->tagsArray[] = 'a';
    if ( $user_group[$member_id['user_group']]['allow_image'] ) $parse->tagsArray[] = 'img';
    $comments = $parse->BB_Parse( $parse->process( trim( $_POST['comments'] ) ) );
}
if ( intval( $dlemovie->config['comments_minsize'] ) AND dle_strlen( str_replace( " ", "", strip_tags( trim( $comments ) ) ), $config['charset'] ) < $dlemovie->config['comments_minsize'] ) {
    $stop[] = $lang['news_err_40'];
    $CN_HALT = TRUE;
}
if ( $user_group[$member_id['user_group']]['captcha'] ) {
    if ( $config['allow_recaptcha'] ) {
        require_once ENGINE_DIR . '/classes/recaptcha.php';
        $_REQUEST['sec_code'] = 1;
        $_SESSION['sec_code_session'] = false;
        if ( $_POST['recaptcha_response_field'] AND $_POST['recaptcha_challenge_field'] ) {
            $resp = recaptcha_check_answer( $config['recaptcha_private_key'], $_SERVER['REMOTE_ADDR'], $_POST['recaptcha_challenge_field'], $_POST['recaptcha_response_field'] );
            if ( $resp->is_valid ) {
                $_REQUEST['sec_code'] = 1;
                $_SESSION['sec_code_session'] = 1;
            }
        }
    }
} else {
    $_SESSION['sec_code_session'] = 1;
    $_REQUEST['sec_code'] = 1;
}
if ( $is_logged and ( $member_id['restricted'] == 2 or $member_id['restricted'] == 3 ) ) {
    $stop[] = $lang['news_info_3'];
    $CN_HALT = TRUE;
}
if ( dle_strlen( $name, $config['charset'] ) > 20 ) {
    $stop[] = $lang['news_err_1'];
    $CN_HALT = TRUE;
}
if ( preg_match( "/[\||\'|\<|\>|\[|\]|\"|\!|\?|\$|\@|\/|\\\|\&\~\*\{\+]/", $name ) ) {
    $stop[] = $lang['reg_err_4'];
    $CN_HALT = TRUE;
}
if ( dle_strlen( $mail, $config['charset'] ) > 50 AND ! $is_logged ) {
    $stop[] = $lang['news_err_2'];
    $CN_HALT = TRUE;
}
if ( ! $video_id ) {
    $stop[] = 'Video not found!';
    $CN_HALT = TRUE;
}
if ( dle_strlen( $comments, $config['charset'] ) > $dlemovie->config['comments_maxsize'] ) {
    $stop[] = $lang['news_err_3'];
    $CN_HALT = TRUE;
}
if ( $_REQUEST['sec_code'] != $_SESSION['sec_code_session'] OR !$_SESSION['sec_code_session'] ) {
    $stop[] = $lang['news_err_30'];
    $CN_HALT = TRUE;
}
if ( $comments == '' ) {
    $stop[] = $lang['news_err_11'];
    $CN_HALT = TRUE;
}
if ( $parse->not_allowed_tags ) {
    $stop[] = $lang['news_err_33'];
    $CN_HALT = TRUE;
}
if ( $parse->not_allowed_text ) {
    $stop[] = $lang['news_err_37'];
    $CN_HALT = TRUE;
}
if ( $member_id['user_group'] > 2 and intval( $config['flood_time'] ) and ! $CN_HALT ) {
    if ( flooder( $_IP ) == TRUE ) {
        $stop[] = $lang['news_err_4'] . " " . $lang['news_err_5'] . " {$config['flood_time']} " . $lang['news_err_6'];
        $CN_HALT = TRUE;
    }
}
if ( ! $is_logged and $CN_HALT != TRUE ) {
    $db->query( "SELECT name from " . USERPREFIX . "_users where LOWER(name) = '" . strtolower( $name ) . "'" );
    if ( $db->num_rows( ) > 0 ) {
        $stop[] = $lang['news_err_7'];
        $CN_HALT = TRUE;
    }
    $db->free( );
}
if ( empty( $name ) and $CN_HALT != TRUE ) {
    $stop[] = $lang['news_err_9'];
    $CN_HALT = TRUE;
}
if ( $mail != "" ) {
    if ( ! preg_match( "/^[\.A-z0-9_\-]+[@][A-z0-9_\-]+([.][A-z0-9_\-]+)+[A-z]{1,4}$/", $mail ) ) {
        $stop[] = $lang['news_err_10'];
        $CN_HALT = TRUE;
    }
}
if ( intval( $config['auto_wrap'] ) ) {
    if ( $config['charset'] == "utf-8" ) $utf_pref = "u"; else $utf_pref = "";
    $comments = preg_split( '((>)|(<))', $comments, - 1, PREG_SPLIT_DELIM_CAPTURE );
    $n = count( $comments );
    for ( $i = 0; $i < $n; $i ++ ) {
        if ( $comments[$i] == "<" ) {
            $i ++;
            continue;
        }
        $comments[$i] = preg_replace( "#([^\s\n\r]{" . intval( $config['auto_wrap'] ) . "})#{$utf_pref}i", "\\1<br />", $comments[$i] );
    }
    $comments = join( "", $comments );
}
$_SESSION['sec_code_session'] = 0;

if ( $CN_HALT ) msgbox( $lang['all_err_1'], implode( "<br />", $stop ) . "<br /><br /><a href=\"javascript:history.go(-1)\">" . $lang['all_prev'] . "</a>" );
else {
    $update_comments = false;
    if ( $dlemovie->config['comments_concat'] == 'yes' ) {
        $row = $db->super_query( "SELECT id, video_id, user_id, date, text, ip, is_register FROM " . PREFIX . "_dm_comments WHERE video_id = '$video_id' ORDER BY id DESC LIMIT 0,1" );
        if ( $row['id'] > 0 ) {
            if ( $row['user_id'] == $member_id['user_id'] and $row['is_register'] ) $update_comments = true;
            elseif ( $row['ip'] == $_IP and ! $row['is_register'] and ! $is_logged ) $update_comments = true;
            if ( date( "Y-m-d", $row['date'] ) != date( "Y-m-d", $_TIME ) ) $update_comments = false;
            if ( ( ( dle_strlen( $row['text'], $config['charset'] ) + dle_strlen( $comments, $config['charset'] ) ) > $dlemovie->config['comments_maxsize'] ) and $update_comments ) {
                $update_comments = false;
                $stop[] = $lang['news_err_3'];
                $CN_HALT = TRUE;
                msgbox( $lang['all_err_1'], implode( "<br />", $stop ) . "<br /><br /><a href=\"javascript:history.go(-1)\">" . $lang['all_prev'] . "</a>" );
            }
        }
    }
    if ( ! $CN_HALT ) {
        if ( $update_comments ) {
            $comments = $db->safesql( $row['text'] ) . "<br /><br />" . $db->safesql( $comments );
            $db->query( "UPDATE " . PREFIX . "_dm_comments SET date = '$_TIME', text = '{$comments}' WHERE id = '{$row['id']}'" );
        } else {
            $comments = $db->safesql( $comments );
            if ( $is_logged ) $db->query( "INSERT INTO " . PREFIX . "_dm_comments ( video_id, user_id, user_name, date, email, text, ip, is_register ) values ( '$video_id', '$member_id[user_id]', '$member_id[name]', '$_TIME', '$mail', '$comments', '$_IP', '1' )" );
            else $db->query( "INSERT INTO " . PREFIX . "_dm_comments ( video_id, user_id, user_name, date, email, text, ip, is_register ) values ( '$video_id', '0', '$name', '$_TIME', '$mail', '$comments', '$_IP', '0' )" );
            if ( $is_logged ) $db->query( "UPDATE " . PREFIX . "_users SET dm_comments = dm_comments + 1 WHERE user_id = '$member_id[user_id]'" );
			$db->query( "UPDATE " . PREFIX . "_dm_videos SET comments = comments + 1 WHERE id = '$video_id'" );
        }
    } else msgbox( $lang['all_err_1'], implode( "<br />", $stop ) . "<br /><br /><a href=\"javascript:history.go(-1)\">" . $lang['all_prev'] . "</a>" );
}
$clear_value = ( $_POST['editor_mode'] == "wysiwyg" ) ? "tinyMCE.execInstanceCommand('comments', 'mceSetContent', false, '', false)" : "form.comments.value = '';";

if ( ! $CN_HALT ) {
    $tpl->result['content'] = $dlemovie->commentsView( $video_id, '', 0, true );
    $tpl->result['content'] = "<div id=\"blind-animation\" style=\"display:none\">".$tpl->result['content']."<div>";
    $tpl->result['content'] .= "<script language='JavaScript' type=\"text/javascript\">var timeval = new Date().getTime();var form = document.getElementById('dle-comments-form');{$clear_value}</script>";
} else {
    $stop = implode( '<br /><br />', $stop );
    $tpl->result['content'] = "<script language=\"JavaScript\" type=\"text/javascript\">\n";
    $tpl->result['content'] .= "\n DLEalert('" . $stop . "', '". $lang['add_comm']."');\n var timeval = new Date().getTime();\n
    if ( document.getElementById('recaptcha_response_field') ) Recaptcha.reload(); 
    if ( document.getElementById('dle-captcha') ) document.getElementById('dle-captcha').innerHTML = '<img src=\"' + dle_root + 'engine/modules/antibot.php?rand=' + timeval + '\" border=0><br /><a onclick=\"reload(); return false;\" href=\"#\">{$lang['reload_code']}</a>';
    </script>";
}
$tpl->result['content'] = str_replace( '{THEME}', $config['http_home_url'] . 'templates/' . $_REQUEST['skin'], $tpl->result['content'] );

@header( "Content-type: text/html; charset=" . $config['charset'] );
echo $tpl->result['content'];
?>